//////////////////////////////////////////////////////////////////////
////                                                              ////
////  Advantech Co., Ltd	FPGA Design                           ////
////                                                              ////
//////////////////////////////////////////////////////////////////////
////  Project	: TI Shannon EVM FPGA                             ////
////  File name	: shevm_fpga.v			                          ////
////  Description                                                 ////
////      		: Shannon EVM FPGA Core MODULE                    ////
////  Created Date                                                ////
////			: 2010/12/09									  ////
//////////////////////////////////////////////////////////////////////
////                                                              ////
//// Copyright (C) 2010 Advantech Co., Ltd                        ////
////                                                              ////
//////////////////////////////////////////////////////////////////////

	`include "params.v"


module shevm_fpga (
		//GLOBAL
	MAIN_48MHZ_CLK_R_p,
	VCC3_AUX_PGOOD_p,

		//DSP SPI
	DSP_SSPCS1_p,
	DSP_SSPCK_p,
	DSP_SSPMISO_p,
	DSP_SSPMOSI_p,
	
		//POWER ON
	VCC5_PGOOD_p,
	VCC2P5_PGOOD_p,
	VCC0P75_PGOOD_p,
	VCC1P5_PGOOD_p,
	SYS_PGOOD_p,
	VCC1P8_PGOOD_p,
	VCC1P5_EN_p,
	VCC1P8_EN1_p,
	VCC0P75_EN_p,
	VCC2P5_EN_p,
	VCC_5V_EN_p,
	
		//GPIO
	BM_GPIO_p,
	DSP_GPIO_p,
	USER_DEFINE_p,
	
		//DEBUG
	DEBUG_LED_p,
	
		//DSP CONTROL
	DSP_PACLKSEL_p,
	DSP_LRESETNMIENZ_p,
	DSP_CORESEL_p,
	DSP_NMIZ_p,
	DSP_LRESETZ_p,
	DSP_HOUT_p,
	DSP_BOOTCOMPLETE_p,
	DSP_SYSCLKOUT_p,
	DSP_PORZ_p,
	DSP_RESETFULLZ_p,
	DSP_RESETZ_p,
	DSP_RESETSTAT_np,
	
		//TI MMC
	MMC_DETECT_np,
	MMC_RESETSTAT_np,
	MMC_POR_IN_AMC_np,
	MMC_WR_AMC_np,
	MMC_BOOTCOMPLETE_p,
	
		//PHY
	PHY_INT_np,
	PHY_RST_np,
	
		//RESET
	FULL_RESET_p,
	WARM_RESET_p,
	COLD_RESET_p,
	FPGA_RST_N_p,
	
		//MISC
	DSP_VCL_1_p,
	DSP_VD_1_p,
	NAND_WP_p,
	XDS560_IL_p,
	NOR_WP_np,
	EEPROM_WP_p,
	PCA9306_EN_p,
	TRGRSTZ_p, 
	PCIESSEN_p,  
	DSP_TIMI0_p,             
	
		//CLOCK
	CLOCK2_SSPCS1_p,
	CLOCK2_SSPCK_p,
	CLOCK2_SSPSI_p,
	CLOCK2_SSPSO_p,
	REFCLK2_PD_np,
	CLOCK2_PLL_LOCK_p,	
	CLOCK3_SSPCS1_p,
	CLOCK3_SSPCK_p,
	CLOCK3_SSPSI_p,
	CLOCK3_SSPSO_p,
	REFCLK3_PD_np,
	CLOCK3_PLL_LOCK_p,
	
		//UCD9222
	UCD9222_PG1_p,
	UCD9222_PG2_p,
	UCD9222_ENA1_p,
	UCD9222_ENA2_p,
	PGUCD9222_p,
	UCD9222_RST_np,
	
		//PMBUS
	PMBUS_CLK_p,
	PMBUS_DAT_p,
    PMBUS_ALT_p, 
	PMBUS_CTL_p,	
	
		//DIFFERENTiAL to SINGLE-ENDED
	TDM_CLKA_N_p,TDM_CLKA_P_p,
//	TDM_CLKB_N_p,TDM_CLKB_P_p,
	TDM_CLKC_N_p,TDM_CLKC_P_p,
//	TDM_CLKD_N_p,TDM_CLKD_P_p,
	TP13, TP14,
	DSP_TSIP0_CLKA0_p,
	DSP_TSIP0_CLKB0_p,
	DSP_TSIP1_CLKA1_p,
	DSP_TSIP1_CLKB1_p,
	DSP_TSIP0_FSA0_p,
	DSP_TSIP0_FSB0_p,
	DSP_TSIP1_FSA1_p,
	DSP_TSIP1_FSB1_p,
	
	   //PCIE CLOCK MUX Control
   FPGA_ICS557_OE_p,
   FPGA_ICS557_PD_np,
   FPGA_ICS557_SEL_p,	
	
	 //VID OE ENABLE 
	 VID_OE_np
	

);

/*******************************/  
/**** 	GLOBAL	   *****/
/*******************************/
input		MAIN_48MHZ_CLK_R_p;
input		VCC3_AUX_PGOOD_p;

wire		main_48mhz_clk_r_i;
wire		vcc3_aux_pgood_i;

/*******************************/  
/**** 	MMC SPI	   *****/
/*******************************/
input		DSP_SSPCS1_p;
input		DSP_SSPCK_p;
output		DSP_SSPMISO_p;
input		DSP_SSPMOSI_p;

wire		dsp_sspcs1_i;
wire		dsp_sspck_i;
wire		dsp_sspmiso_o;
wire		dsp_sspmosi_i;

/*******************************/  
/**** 	POWER ON	   *****/
/*******************************/
input		VCC5_PGOOD_p;
input		VCC2P5_PGOOD_p;
input		VCC0P75_PGOOD_p;
input		VCC1P5_PGOOD_p;
output		SYS_PGOOD_p;
input		VCC1P8_PGOOD_p;

output		VCC1P5_EN_p;
output		VCC1P8_EN1_p;
output		VCC0P75_EN_p;
output		VCC2P5_EN_p;
output		VCC_5V_EN_p;
//input		VCC_5V_EN_p;//troy 20110407

wire		vcc5_pgood_i;
wire		vcc2p5_pgood_i;
wire		vcc0p75_pgood_i;
wire		vcc1p5_pgood_i;
wire		sys_pgood_o;
wire		vcc1p8_pgood_i;

wire		vcc1p5_en_o;
wire		vcc1p8_en1_o;
wire		vcc0p75_en_o;
wire		vcc2p5_en_o;
wire		vcc_5v_en_o;

/*******************************/  
/**** 	GPIO	   *****/
/*******************************/
input	[15:0]	BM_GPIO_p;
inout	[15:0]	DSP_GPIO_p;
input		USER_DEFINE_p;   //20101205

wire	[15:0]	bm_gpio_i;
wire	[15:0]	dsp_gpio_i;
wire	[15:0]	dsp_gpio_o;
wire		dsp_gpio_en;
wire		user_define_i;   //20101205

wire    gpio3_alt_miso;      ///////////////////////////////////////test    
wire    gpio3_alt_miso_outen;  ///////////////////////////////////////test

/*******************************/  
/**** 	DEBUG	   *****/
/*******************************/
output	[3:0]	DEBUG_LED_p;

wire	[3:0]	debug_led_o;

/*******************************/  
/**** 	DSP CONTROL	   *****/
/*******************************/
output		DSP_PACLKSEL_p;
output		DSP_LRESETNMIENZ_p;
output	[3:0]	DSP_CORESEL_p;
output		DSP_NMIZ_p;
output		DSP_LRESETZ_p;
input		DSP_HOUT_p;
input		DSP_BOOTCOMPLETE_p;
input		DSP_SYSCLKOUT_p;
output		DSP_PORZ_p;
output		DSP_RESETFULLZ_p;
output		DSP_RESETZ_p;
input		DSP_RESETSTAT_np;

wire		dsp_paclksel_o;
wire		dsp_lresetnmienz_o;
wire	[3:0]	dsp_coresel_o;
wire		dsp_nmiz_o;
wire		dsp_lresetz_o;
wire		dsp_hout_i;
wire		dsp_bootcomplete_i;
wire		dsp_sysclkout_i;
wire		dsp_porz_o;
wire		dsp_resetfullz_o;
wire		dsp_resetz_o;
wire		dsp_resetstat_ni;

/*******************************/  
/**** 	TI MMC	   *****/
/*******************************/
input		MMC_DETECT_np;
output		MMC_RESETSTAT_np;
input		MMC_POR_IN_AMC_np;
input		MMC_WR_AMC_np;
output		MMC_BOOTCOMPLETE_p;

wire		mmc_detect_ni;
wire		mmc_resetstat_no;
wire		mmc_por_in_amc_ni;
wire		mmc_wr_amc_ni;
wire		mmc_bootcomplete_o;

/*******************************/  
/**** 	PHY	   *****/
/*******************************/
input		PHY_INT_np;
output		PHY_RST_np;

wire		phy_int_ni;
wire		phy_rst_no;

/*******************************/  
/**** 	RESET	   *****/
/*******************************/
input		FULL_RESET_p;
input		WARM_RESET_p;
input		COLD_RESET_p;
input		FPGA_RST_N_p;

wire		full_reset_i;
wire		warm_reset_i;
wire		cold_reset_i;
wire		fpga_rst_n_i;	

/*******************************/  
/**** 	other	   *****/
/*******************************/
input		DSP_VCL_1_p;  //20101205
inout		DSP_VD_1_p;   //20101205
output		NAND_WP_p;
output		XDS560_IL_p;
output		NOR_WP_np;
output		EEPROM_WP_p;
output		PCA9306_EN_p;

input       TRGRSTZ_p;
input       PCIESSEN_p;

output		DSP_TIMI0_p; 

wire		dsp_vcl_1_i;  //20101205
wire		dsp_vd_1_o;
wire		nand_wp_o;
wire		xds560_il_o;
wire		nor_wp_no;
wire		eeprom_wp_o;
wire		pca9306_en_o;

wire 		fpga_update_en;  //20101227
wire   		update_miso;  // 1-bit SPI output data
wire   		update_mosi; // 1-bit SPI input data
wire		update_csb;  // 1-bit SPI chip enable
wire		update_clk;  

wire        trgrst_i;
wire        pciessen_i;

wire		dsp_timi0_o; 

/*******************************/  
/**** 	CLOCK	   *****/
/*******************************/
output		CLOCK2_SSPCS1_p;
output		CLOCK2_SSPCK_p;
output		CLOCK2_SSPSI_p;
input		CLOCK2_SSPSO_p;
output		REFCLK2_PD_np;
input		CLOCK2_PLL_LOCK_p;
output		CLOCK3_SSPCS1_p;
output		CLOCK3_SSPCK_p;
output		CLOCK3_SSPSI_p;
input		CLOCK3_SSPSO_p;
output		REFCLK3_PD_np;
input		CLOCK3_PLL_LOCK_p;

wire		clock2_sspcs1_o;
wire		clock2_sspck_o;
wire		clock2_sspsi_o;
wire		clock2_sspso_i;
wire		refclk2_pd_no;
wire		clock2_pll_lock_i;
wire		clock3_sspcs1_o;
wire		clock3_sspck_o;
wire		clock3_sspsi_o;
wire		clock3_sspso_i;
wire		refclk3_pd_no;
wire		clock3_pll_lock_i;

/*******************************/  
/**** 	UCD9222	   *****/
/*******************************/
input		UCD9222_PG1_p;
input		UCD9222_PG2_p;
output		UCD9222_ENA1_p;
output		UCD9222_ENA2_p;
input		PGUCD9222_p;
output		UCD9222_RST_np;
wire		UCD9222_RST_np;  //20110210

wire		ucd9222_pg1_i;
wire		ucd9222_pg2_i;
wire		ucd9222_ena1_o;
wire		ucd9222_ena2_o;
wire		pgucd9222_i;
wire		ucd9222_rst_no;

/*******************************/  
/**** 	PMBUS	   *****/
/*******************************/
//output		PMBUS_CLK_p;
input		PMBUS_CLK_p;  //20101229 for test
//inout		PMBUS_DAT_p;
input		PMBUS_DAT_p;  //20101229 for test
input		PMBUS_ALT_p; 
input		PMBUS_CTL_p;	

wire		pmbus_clk_o;
wire		pmbus_dat_i;
wire		pmbus_dat_o;
wire		pmbus_dat_en;
wire		pmbus_alt_i;
wire		pmbus_ctl_i;//input for test only

/*******************************/  
/**** 	DIFFERENT to SINGLE CLOCK	   *****/
/*******************************/
input		TDM_CLKA_P_p;
input		TDM_CLKA_N_p;
//input		TDM_CLKB_P_p;
//input		TDM_CLKB_N_p;
input		TDM_CLKC_P_p;
input		TDM_CLKC_N_p;
//input		TDM_CLKD_P_p;
//input		TDM_CLKD_N_p;

output		TP13, TP14;
wire		TP13, TP14;

output		DSP_TSIP0_CLKA0_p;
output		DSP_TSIP0_CLKB0_p;
output		DSP_TSIP1_CLKA1_p;
output		DSP_TSIP1_CLKB1_p;
output		DSP_TSIP0_FSA0_p;
output		DSP_TSIP0_FSB0_p;
output		DSP_TSIP1_FSA1_p;
output		DSP_TSIP1_FSB1_p;	

/***************************************/  
/**** 	PCIE CLOCK MUX CONTROL	  *****/
/***************************************/
output    FPGA_ICS557_OE_p;
output    FPGA_ICS557_PD_np;
output    FPGA_ICS557_SEL_p;

   
   
   	
output    VID_OE_np;	






///////////////// DPS SPI model for FPGA IO test in chipscope 
wire		fpga_DSP_CSB;
wire		fpga_DSP_MISO;
wire  		model_DSP_CSB;
wire 		model_DSP_CLK;
wire		model_DSP_MOSI;
wire 		model_DSP_MISO;
wire		set_mmc_por_n;
wire		set_mmc_wr_n;
wire		gpio_DSP_CSB;
wire		gpio_DSP_CLK;
wire		gpio_DSP_MOSI;
wire		gpio_DSP_MISO;
wire        test_gpio_spi;
wire		DSP_SSPMISO_p;
//////
`ifdef IO_Test
	assign 		DSP_SSPMISO_p = model_DSP_MISO;   ///////// for chipscope IO test only
	assign		model_DSP_MISO = (test_gpio_spi)? gpio_DSP_MISO : fpga_DSP_MISO;
	assign		fpga_DSP_CSB = (test_gpio_spi)? 1'b1 : model_DSP_CSB;
	assign 		gpio_DSP_CSB = (test_gpio_spi)? model_DSP_CSB : dsp_gpio_i[1];
	assign 		gpio_DSP_CLK = (test_gpio_spi)? model_DSP_CLK : dsp_gpio_i[0];
	assign 		gpio_DSP_MOSI = (test_gpio_spi)? model_DSP_MOSI : dsp_gpio_i[2];
	assign		gpio_DSP_MISO = gpio3_alt_miso;
`endif
wire 		rst_n; 
wire		sync_start; 
wire		sync_r_wn;
wire [6:0]	sync_addr;
wire [7:0] 	sync_data_w;
wire [7:0]  reg_data_r;
wire		rdy;

wire [31:0] debug_sig;

shevm_fpga_pad pad(
		//GLOBAL
	MAIN_48MHZ_CLK_R_p,VCC3_AUX_PGOOD_p,
	
	main_48mhz_clk_r_i,vcc3_aux_pgood_i,	
	
		//DSP SPI

	DSP_SSPCS1_p,DSP_SSPCK_p,DSP_SSPMISO_p,DSP_SSPMOSI_p,   

	//

	dsp_sspcs1_i,dsp_sspck_i,dsp_sspmiso_o,dsp_sspmosi_i,
	
		//POWER ON
	VCC5_PGOOD_p,VCC2P5_PGOOD_p,VCC0P75_PGOOD_p,VCC1P5_PGOOD_p,SYS_PGOOD_p,VCC1P8_PGOOD_p,
	VCC1P5_EN_p,VCC1P8_EN1_p,VCC0P75_EN_p,VCC2P5_EN_p,VCC_5V_EN_p,
	
	vcc5_pgood_i,vcc2p5_pgood_i,vcc0p75_pgood_i,vcc1p5_pgood_i,sys_pgood_o,vcc1p8_pgood_i,
	vcc1p5_en_o,vcc1p8_en1_o,vcc0p75_en_o,vcc2p5_en_o,vcc_5v_en_o,
	
		//GPIO
	BM_GPIO_p,DSP_GPIO_p,USER_DEFINE_p,
	
	bm_gpio_i,dsp_gpio_i,dsp_gpio_o,dsp_gpio_en,user_define_i,
	
	gpio3_alt_miso,         
    gpio3_alt_miso_outen,
	
		//DEBUG
	DEBUG_LED_p,
	
	debug_led_o,
	
		//DSP CONTROL
	DSP_PACLKSEL_p,DSP_LRESETNMIENZ_p,DSP_CORESEL_p,DSP_NMIZ_p,DSP_LRESETZ_p,DSP_HOUT_p,DSP_BOOTCOMPLETE_p,
	DSP_SYSCLKOUT_p,DSP_PORZ_p,DSP_RESETFULLZ_p,DSP_RESETZ_p,DSP_RESETSTAT_np,

	dsp_paclksel_o,dsp_lresetnmienz_o,dsp_coresel_o,dsp_nmiz_o,dsp_lresetz_o,dsp_hout_i,dsp_bootcomplete_i,
	dsp_sysclkout_i,dsp_porz_o,dsp_resetfullz_o,dsp_resetz_o,dsp_resetstat_ni,
	
		//TI MMC
	MMC_DETECT_np,MMC_RESETSTAT_np,MMC_POR_IN_AMC_np,MMC_WR_AMC_np,MMC_BOOTCOMPLETE_p,
	
	mmc_detect_ni,mmc_resetstat_no,mmc_por_in_amc_ni,mmc_wr_amc_ni,mmc_bootcomplete_o,
	
		//PHY
	PHY_INT_np,PHY_RST_np,
	
	phy_int_ni,phy_rst_no,
	
		//RESET
	FULL_RESET_p,WARM_RESET_p,COLD_RESET_p,FPGA_RST_N_p,
	
	full_reset_i,warm_reset_i,cold_reset_i,fpga_rst_n_i,
	
		//OTHER
	DSP_VCL_1_p,DSP_VD_1_p,NAND_WP_p,XDS560_IL_p,NOR_WP_np,EEPROM_WP_p,PCA9306_EN_p,
		
	dsp_vcl_1_i,dsp_vd_1_o,nand_wp_o,xds560_il_o,nor_wp_no,eeprom_wp_o,pca9306_en_o,
	
	fpga_update_en,  update_miso, update_mosi, update_csb, update_clk,  
	
	TRGRSTZ_p, trgrstz_i,
	PCIESSEN_p, pciessen_i,
	DSP_TIMI0_p, dsp_timi0_o,
	
		//CLOCK
	CLOCK2_SSPCS1_p,CLOCK2_SSPCK_p,CLOCK2_SSPSI_p,CLOCK2_SSPSO_p,REFCLK2_PD_np,CLOCK2_PLL_LOCK_p,
	CLOCK3_SSPCS1_p,CLOCK3_SSPCK_p,CLOCK3_SSPSI_p,CLOCK3_SSPSO_p,REFCLK3_PD_np,CLOCK3_PLL_LOCK_p,
	
	clock2_sspcs1_o,clock2_sspck_o,clock2_sspsi_o,clock2_sspso_i,refclk2_pd_no,clock2_pll_lock_i,
	clock3_sspcs1_o,clock3_sspck_o,clock3_sspsi_o,clock3_sspso_i,refclk3_pd_no,clock3_pll_lock_i,
	
		//UCD9222	
	UCD9222_PG1_p,UCD9222_PG2_p,UCD9222_ENA1_p,UCD9222_ENA2_p,PGUCD9222_p,UCD9222_RST_np,

	ucd9222_pg1_i,ucd9222_pg2_i,ucd9222_ena1_o,ucd9222_ena2_o,pgucd9222_i,ucd9222_rst_no,	
	
	//PMBUS
	PMBUS_CLK_p,PMBUS_DAT_p, PMBUS_ALT_p, PMBUS_CTL_p,
	
	pmbus_clk_o,pmbus_dat_i,pmbus_dat_o,pmbus_dat_en, pmbus_alt_i, pmbus_ctl_i,//input for test only
	
		//DIFFERENTIAL to SINGLE CLOCK
	TDM_CLKA_N_p, TDM_CLKA_P_p, TDM_CLKB_N_p, TDM_CLKB_P_p,
	TDM_CLKC_N_p, TDM_CLKC_P_p, TDM_CLKD_N_p, TDM_CLKD_P_p,
	
	TP13, TP14,
		
	DSP_TSIP0_CLKA0_p, DSP_TSIP0_CLKB0_p, DSP_TSIP1_CLKA1_p, DSP_TSIP1_CLKB1_p,
	DSP_TSIP0_FSA0_p, DSP_TSIP0_FSB0_p, DSP_TSIP1_FSA1_p, DSP_TSIP1_FSB1_p,

   //PCIE CLOCK MUX CONTROL  	
  FPGA_ICS557_OE_p, FPGA_ICS557_PD_np, FPGA_ICS557_SEL_p,
	fpga_ics557_oe_o, fpga_ics557_pd_no, fpga_ics557_sel_o,
	
	 //VID OE CONTROL
	VID_OE_np,
	vid_oe_no  
	 
);






shevm_fpga_core core(	
		//GLOBAL	
	main_48mhz_clk_r_i,   	//FPGA 48MHZ Reference clock source
	vcc3_aux_pgood_i,     	//FPGA power good indication
	//power_on,               //chipscope for power trigger  //matt1229
	
		//DSP SPI	
	dsp_sspcs1_i,		  	//DSP SPI Chip Select
	dsp_sspck_i,			//DSP SPI clock
	dsp_sspmiso_o,			//DSP SPI data input from FPGA
	dsp_sspmosi_i,          //DSP SPI data output to FPGA
	
		//POWER ON	
	vcc5_pgood_i,			//5V power good indication
	vcc2p5_pgood_i,			//2.5V power good indication
	vcc1p8_pgood_i,         //1.8V power good indication
	vcc1p5_pgood_i,			//1.5V power good indication
	vcc0p75_pgood_i,		//0.75V power good indication

	sys_pgood_o,			//system power good indication
	
	vcc_5v_en_o,    		//5V power enable
	vcc2p5_en_o,			//2.5V power enable
	vcc1p8_en1_o,          	//1.8V power enable
	vcc1p5_en_o,			//1.5V power enable		
	vcc0p75_en_o,			//0.75V power enable
	
		//GPIO
	bm_gpio_i,	           //Boot Mode switch inputs

	dsp_gpio_i,			  //DSP GPIO inputs	
		
	dsp_gpio_o,				//DSP GPIO outputs for boot strapping
	dsp_gpio_en,			//DSP GPIO IO control
	
	gpio3_alt_miso,         
    gpio3_alt_miso_outen,
	
		//RESET	buttons & input switch
	full_reset_i,			//full reset button input
	cold_reset_i,			//hard(cold) reset button input
	warm_reset_i,			//warm reset button input
	fpga_rst_n_i,			//FPGA JTAG reset input
	trgrstz_i, 				//trgrst from emulation card
	pciessen_i,				//PCIESSEN switch for boot strapping
	user_define_i,  		//User Defined switch input
	
		//DEBUG	
	debug_led_o,			//Debug LEDs
	
		//DSP Interface 
	dsp_porz_o,				//DSP POR
	dsp_resetfullz_o,		//DSP Full Reset
	dsp_resetz_o,			//DSP Reset
	dsp_lresetz_o,			//DSP local reset
	dsp_coresel_o,			//DSP core select
	dsp_resetstat_ni,		//DSP resetstat
	dsp_nmiz_o,				//DSP NMI
	dsp_lresetnmienz_o,		//DSP Lreset and NMI enable
	dsp_bootcomplete_i,		//DSP boot complete indication
	dsp_paclksel_o,			//DSP PA clock select
	dsp_hout_i,				//DSP HOUT
	dsp_sysclkout_i,		//DSP SYSCLKOUT
	dsp_timi0_o,			//DSP Timier 0 and PCIESSEN boot strapping
	
		//MMC Interface	
	mmc_detect_ni,			//MMC detect
	mmc_resetstat_no,		//MMC resetstat from DSP resetstat

	mmc_por_in_amc_ni,		//MMC POR request
	mmc_wr_amc_ni,			//MMC warm reset request

	mmc_bootcomplete_o,		//MMC boot complete from DSP boot complete
	
		//PHY Interface	
	phy_int_ni,				//PHY Interrupt
	phy_rst_no,				//PHY reset
	
		//UCD9222	
	ucd9222_pg1_i,			//ucd9222 #1 power good and also for the CVDD DSP core power good
	ucd9222_pg2_i,			//ucd9222 #2 power good and also for the VCC1V0 DSP core power good
	ucd9222_ena1_o,   		//ucd9222 #1 power and the CVDD DSP core power enable
	ucd9222_ena2_o,			//ucd9222 #2 power and the VCC1V0 DSP core power enable
	pgucd9222_i,			//both ucd9222 and the VCC1V0/CVDD DSP core power are valid
	ucd9222_rst_no,			//ucd9222 reset
	
		//PMBUS	& Smart-Reflex
	dsp_vcl_1_i,			//DSP smart-reflex clock
	dsp_vd_1_o,				//DSP smrat-reflex data
	pca9306_en_o,			//smart-reflex buffer enable
	pmbus_clk_o,			//PM bus clock
	pmbus_dat_i,			//PM bus data in
	pmbus_dat_o,			//PM bus data out
	pmbus_dat_en,			//PM bus data IO control
	
		//MISC	
	nand_wp_o,				//NAND flash write protect
	nor_wp_no,				//NOR flash write protect
	eeprom_wp_o,			//EEPROM write protect
	xds560_il_o,			//XDS560 inter-lock
	
	fpga_update_en,         //FPGA update enable
	 	
		//CLOCK Generator SPI interface & Control
	clock2_sspcs1_o,
	clock2_sspck_o,
	clock2_sspsi_o,
	clock2_sspso_i,
	refclk2_pd_no,
	clock2_pll_lock_i,
	clock3_sspcs1_o,
	clock3_sspck_o,
	clock3_sspsi_o,
	clock3_sspso_i,
	refclk3_pd_no,
	clock3_pll_lock_i,
	debug_sig,
	
		//DIFFERENT to SINGLE CLOCK
	/*
	tdm_clka_n_i,
	tdm_clkc_n_i,
	
	dsp_tsip0_clka0_o,
	dsp_tsip0_clkb0_o,
	dsp_tsip1_clka1_o,
	dsp_tsip1_clkb1_o,
	dsp_tsip0_fsa0_o,
	dsp_tsip0_fsb0_o,
	dsp_tsip1_fsa1_o,
	dsp_tsip1_fsb1_o			*/

		//PCIE SWITCH CLOCK CONTROL	
	fpga_ics557_oe_o, fpga_ics557_pd_no, fpga_ics557_sel_o,
	
	  //VID OE CONTROL
	vid_oe_no  	
	
);	


SPI_ACCESS #(
        .SIM_DEVICE("3S200AN") 
        ) 
U_SPI_ACCESS_flash (
        .MISO(update_miso),  // 1-bit SPI output data
        .MOSI(update_mosi),  // 1-bit SPI input data
        .CSB(update_csb),    // 1-bit SPI chip enable
        .CLK(update_clk)     // 1-bit SPI clock input
        );

endmodule 

